# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 9
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR9_strategy.txt
# LLM Suggested Fallback: D

def harmony_optimizer_v9(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    rounds_played = len(my_history)
    trust_counter = sum(1 for m in opp_history if m == 'D')  # Actually counts defections
    
    # Initial Trust-Building Phase (Rounds 1-3)
    if rounds_played == 0:
        return 'C'  # Build trust initially
    elif rounds_played == 1:
        return 'D'  # Test opponent's reaction
    elif rounds_played == 2:
        return 'C' if opp_history[-1] == 'C' else 'D'  # Fake forgiveness
    
    # Mid-Game Exploitation (Rounds 4-7)
    elif 3 <= rounds_played <= 6:
        if opp_history[-1] == 'C' and opp_history[-2] == 'C':
            return 'D' if rounds_played % 2 == 0 else 'C'  # Alternate to exploit
        else:
            return 'D' if opp_history[-1] == 'D' and opp_history[-2] == 'D' else 'C'  # Tit-for-Two-Tats
    
    # Late-Game Aggression (Rounds 8-10)
    elif rounds_played >= 7:
        return 'D'  # Unconditional defection
    
    # Default fallback
    return 'D'